@echo off
REM Provide a user interface for the USB datalogger command line tools
SET NAME=-n T808Logger
SET INTERVAL=0
SET MODE=-c
SET TLOG=bin\x64\t808logx64.exe
SET BRESULT=true
SET DRVINST=driver\USBXpressInstaller_x64.exe
SET REDISTINST=redist\vc_redist_x64.exe
IF "%PROCESSOR_ARCHITECTURE%"=="x86" (SET REDISTINST=redist\vc_redist_x86.exe)
IF "%PROCESSOR_ARCHITECTURE%"=="x86" (SET TLOG=bin\x86\t808log.exe)
IF "%PROCESSOR_ARCHITECTURE%"=="x86" (SET DRVINST=driver\USBXpressInstaller_x86.exe)
echo *** HEYL USB DATA LOGGER V1.4 - TESTOMAT 808 ***
echo.
:lblFunktion
SET /P X=Datalogger (c)onfigure (r)ead, (H)elp, (D)river install?
IF /I "%X%" == "r" GOTO lblRead
IF /I "%X%" == "c" GOTO lblConf
IF /I "%X%" == "h" GOTO lblHelp
IF /I "%X%" == "d" GOTO lblDriver
echo Wrong input, please repeat
goto lblFunktion
:lblDriver
REM Install driver and Visual Studio runtime
start /WAIT %DRVINST%
start /WAIT %REDISTINST%
goto lblFinish
:lblHelp
REM Show PDF, PDF viewer must be installed
start doc\Testomat808_USB_Datenlogger_E.pdf
goto lblFinish
:lblRead
echo Read data logger
%TLOG% -d
SET /P X=Restart datalogger (y/n)?
IF /I not "%X%" == "y" GOTO lblEnd
call startlog.bat
GOTO lblEnd
:lblConf
echo.
echo Configure data logger:
SET /P SW=Input setting of switch S6 in Testomat 808 (0-9) or sample interval in seconds: 
SET INTERVAL=%SW%
IF /I "%SW%" == "0" (SET INTERVAL=120)
IF /I "%SW%" == "1" (SET INTERVAL=360)
IF /I "%SW%" == "2" (SET INTERVAL=600)
IF /I "%SW%" == "3" (SET INTERVAL=900)
IF /I "%SW%" == "4" (SET INTERVAL=1200)
IF /I "%SW%" == "5" (SET INTERVAL=1620)
IF /I "%SW%" == "6" (SET INTERVAL=1800)
IF /I "%SW%" == "7" (SET INTERVAL=2400)
IF /I "%SW%" == "8" (SET INTERVAL=3000)
IF /I "%SW%" == "9" (SET INTERVAL=3600)
:lblName
echo.
SET /P NEWNAME=New name instead of 'T808Logger' (enter new name or '-' / Return)?
IF /I NOT "%NEWNAME%" == "-" IF NOT "%NEWNAME%" == "" (SET BRESULT=false)
IF %BRESULT%==false (SET NAME=-n %NEWNAME%) ELSE (echo Current name persists)
:lblAskImm
SET /P IMMEDIATE=Start (i)mmediately or after (k)eypress?
IF /I "%IMMEDIATE%" == "i" (SET MODE=-r) ELSE (SET MODE=-c)
REM *** Execute Program ***
echo.
echo Settings are:
echo - Data logger's name: %NAME%
echo - Sample interval[s]: %INTERVAL%
IF /I "%IMMEDIATE%" == "i" (echo - Start immediately) ELSE (echo - Start after keypress)
%TLOG% %NAME% -i %INTERVAL% %MODE%
echo %TLOG% %NAME% -i %INTERVAL% %MODE% > startlog.bat
:lblEnd
pause
:lblFinish