@echo off
REM Benutzerfuehrung fuer T808 USB Datenlogger Werkzeuge
SET NAME=-n T808Logger
SET INTERVAL=0
SET MODE=-c
SET TLOG=bin\x64\t808logx64.exe
SET BRESULT=true
SET DRVINST=driver\USBXpressInstaller_x64.exe
SET REDISTINST=redist\vc_redist_x64.exe
IF "%PROCESSOR_ARCHITECTURE%"=="x86" (SET REDISTINST=redist\vc_redist_x86.exe)
IF "%PROCESSOR_ARCHITECTURE%"=="x86" (SET TLOG=bin\x86\t808log.exe)
IF "%PROCESSOR_ARCHITECTURE%"=="x86" (SET DRVINST=driver\USBXpressInstaller_x86.exe)
echo *** HEYL USB DATENLOGGER V1.4 - TESTOMAT 808 ***
echo.
:lblFunktion
SET /P X=Datenlogger (k)onfigurieren, (a)uslesen, (H)ilfe, (T)reiber installieren?
IF /I "%X%" == "a" GOTO lblRead
IF /I "%X%" == "k" GOTO lblConf
IF /I "%X%" == "h" GOTO lblHelp
IF /I "%X%" == "t" GOTO lblDriver
echo Falsche Eingabe, bitte wiederholen
goto lblFunktion
:lblDriver
REM Install driver and Visual Studio runtime
start /WAIT %DRVINST%
start /WAIT %REDISTINST%
goto lblEnd
:lblHelp
REM Show PDF, PDF viewer must be installed
start doc\Testomat808_USB_Datenlogger_D.pdf
goto lblEnd
:lblRead
echo Datenlogger auslesen
%TLOG% -d
SET /P X=Datenlogger neu starten (j/n)?
IF /I not "%X%" == "j" GOTO lblEnd
call startlog.bat
GOTO lblEnd
:lblConf
echo.
echo Datenlogger einstellen:
SET /P SW=Stellung S6 eingeben (0-9) oder Messintervall in Sekunden: 
SET INTERVAL=%SW%
IF /I "%SW%" == "0" (SET INTERVAL=120)
IF /I "%SW%" == "1" (SET INTERVAL=360)
IF /I "%SW%" == "2" (SET INTERVAL=600)
IF /I "%SW%" == "3" (SET INTERVAL=900)
IF /I "%SW%" == "4" (SET INTERVAL=1200)
IF /I "%SW%" == "5" (SET INTERVAL=1620)
IF /I "%SW%" == "6" (SET INTERVAL=1800)
IF /I "%SW%" == "7" (SET INTERVAL=2400)
IF /I "%SW%" == "8" (SET INTERVAL=3000)
IF /I "%SW%" == "9" (SET INTERVAL=3600)
:lblName
echo.
SET /P NEWNAME=Neuer Name anstatt 'T808Logger' (Neuen Namen eingeben oder '-' / Return)?
IF /I NOT "%NEWNAME%" == "-" IF NOT "%NEWNAME%" == "" (SET BRESULT=false)
IF %BRESULT%==false (SET NAME=-n %NEWNAME%) ELSE (echo Alter Name bleibt)
:lblAskImm
SET /P IMMEDIATE=Start (s)ofort oder nach (K)nopfdruck?
IF /I "%IMMEDIATE%" == "s" (SET MODE=-r) ELSE (SET MODE=-c)
REM *** Execute Program ***
echo.
echo Die Einstellungen sind:
echo - Name des Datenloggers: %NAME%
echo - Messinterval      [s]: %INTERVAL%
IF /I "%IMMEDIATE%" == "s" (echo - Start sofort) ELSE (echo - Start nach Knopfdruck)
%TLOG% %NAME% -i %INTERVAL% %MODE%
echo %TLOG% %NAME% -i %INTERVAL% %MODE% > startlog.bat
:lblEnd
pause
